import os, sys
import glob
import string
from math import *
import numpy as np 
from scipy import sparse
# import pyexiv2
import fractions
import math
import datetime
# import ephem
import time

def is_Daylight_Savings(date_str):
	# Function takes a date as a string in (20150624_152835_244) format and outputs a
	# logical, true if the date is during daylight savings time for that year. See
	# definition of daylight savings time in the USA
	date_str = date_str.split("_")[0]

	year = int(date_str[0:4])
	month = int(date_str[4:6])
	day = int(date_str[6:8])

	# If the month is between April and October, true
	if ((month > 3) and (month < 11)): return True 
	# If month is January, February, or December, false
	elif ((month < 3) or (month == 12)): return False 
	if (month == 3): # days on/after 2nd Sunday in March, true
		sundays = 0
		for i in xrange(day+1):
			if datetime.date(year, month, day).isoweekday() == 7: 
				sundays += 1
		if sundays >= 2: 
			return True
		else: 
			return False
	elif (month == 11): # days before 1st Sunday in Nov, true
		sundays = 0
		for i in xrange(day):
			if datetime.date(year, month, day).isoweekday() == 7: 
				sundays += 1
		if sundays < 1: 
			return True
		else: 
			return False




